/* Uses a user supplied hue along with a texture that contains red=saturation, green=value, blue = alpha to dynamically color a graphic */

#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;
out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform float hue;
uniform float saturation;
uniform float brightness;
uniform float fade;

const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);

void main()
{
#ifdef GL_ES
	vec4 readColor = vec4(hue, texture2D(colorTex, vTexCoord.xy).rgb);
#else
    vec4 readColor = vec4(hue, texture(colorTex, vTexCoord.xy).rgb);
#endif
	vec3 p = abs(fract(readColor.rrr + K.rgb) * 6.0 - K.aaa);
	
	vec3 finalColor = readColor.b * brightness * mix(K.rrr, clamp(p - K.rrr, 0.0, 1.0), readColor.g * saturation);
	vec3 gamma22 = clamp(pow(finalColor, vec3(2.2 / 1.0)), 0.0, 1.0);
	fragColor = vec4(gamma22 * readColor.a, 1.0) * fade * readColor.a;
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
